/*------------------------------------------------------------------------------*
 * File Name:NLFitDlg.c/h	 													*
 * Creation: CPY 05-05-2008														*
 * Purpose: Main OC code for NLFit Dialog										*
 * Copyright (c) Originlab Corp. 1992-2008										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Hong 09/11/08 v8.0937 CLEAN_GRID_UPDATE_MECHASNISM_BASE_ON_PARAMETER_MANAGER*
 *	Hong 09/13/08 v8.0938 IMPROVE_BY_AVOID_UPDATE_WHEN_TAB_IS_HIDDEN			*
 *	Hong 10/08/08 QA80-12345 v8.0952c ADD_STAR_INDICATE_THEME_VALUE_CHANGE		*
 *	Kyle 10/22/08 QA80-12401 QUICK_SET_ONE_PARAM_VALUE_TO_ALL					*
 *	Folger 10/24/08 v8.0960 SUPPORT_SORT_PEAKS_FOR_REPLICA						*
 *	Folger 10/24/08 v8.0960 CENTRALIZE_CODE_ABOUT_UPDATING_ON_PARAMETER_CHANGE	*
 *	Kyle 11/04/2008 QUICK_SET_PARAMETERS_VALUE_CHANGE							*
 *	Folger 11/05/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
 *	Hong 11/21/08 QA80-12505 NLFIT_NEED_DATASET_CHANGE_MONITER_ALLOW_CHANGE_DATA_AFTER_OPEN_DLG
 *	Sophy 11/26/2008 v8.980 SHOULD_DISABLE_FITBUTTON_WHEN_HAS_ERR_MSG			*
 *	Folger 12/11/08 v8.0985 SUPPORT_DOUBLE_CLICK_TO_SWICH_BOUND_CONTROL			*
 *	Hong 12/12/08 QA80-12733 ACTIVE_SELECTION_IN_GRAPH_LOST_IF_NOT_ACTIVE_PAGE_LEAD_INIT_INPUT_FAIL
 *	Folger 12/15/08 QA80-12778 v8.0986c DYNAMICALLY_CALCULATE_OPTIMAL_WIDTH_FOR_NLFIT_DIALOG
 *	Hong 01/23/09 MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU				*
 *	Folger 02/11/09 QA80-13098-P1 NLFIT_RESIZE_BAD_WHEN_BOTTOM_PANE_IS_HIDDEN	*
 *	Hong 07/03/09 QA80-13590-P4 ONLY_SWITCH_TO_MSG_TAB_FOR_KEY_MSG_LIKE_CLICK_FIT_BTNS
 *	Hong 09/24/09 QA80-14350 NLFIT_DLG_NEED_HINT_TO_GUIDE_USER_MAKE_IT_MODALLESS*
 *	Hong 01/12/10 QA80-14948 NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN			*
 *	Folger 04/13/10 QA81-15297-P1 ACTIVE_HINT_TAB_WHEN_USER_SELECT_CONSTRAIN_ROW_WITH_EMPTY_CONTENTS
 *------------------------------------------------------------------------------*/

#ifndef _NLFIT_DLG_H
#define _NLFIT_DLG_H

#define _NLF_PARAMS_TAB //---CPY 11/12/06 MARKO_FOUND_CANCEL_CRASH_COMES_FROM_PARAMS_GRID

class NLFitDlg : public MultiPaneDlg
{
public:
	NLFitDlg(PEVENT_GETN pfn) : MultiPaneDlg(IDD_NLFIT_DLG, "ODlg8")
	{
		
		//------ Folger 03/03/08 QA80-11192 ADD_THEME_CONTROL_POPUP_MENU
#ifndef THEME_CONTROL_POPUP_MENU
		vector<uint> vnThemeSaveGroup = {IDC_THEME_TEXT, IDC_THEME_COMB, IDC_SAVE_BTN, IDC_SAVE_AS_BTN, 0};
#else
		vector<uint> vnThemeSaveGroup = {IDC_THEME_TEXT, IDC_THEME_COMB, IDC_SAVE_AS_BTN, 0};
#endif
		//------
		m_vnThemeSaveGroup = vnThemeSaveGroup;
		m_pNewEventFunc = pfn;	///Joseph 01/30/06	ADD_OPERATION_ERRMSG_LINE
		m_bPreviewSrcPage = false; /// Hong 01/21/08 QA80-10969 FITNL_SOPPURT_DO_PREVIEW_ON_SOURCE_GRAPHPAGE
		m_pGridParas = new NLFParamsControl; /// Iris 10/29/2008 QA80-12401-P4 QUICK_SET_DLG_ADD_APPLY_BUUTON
		
		///------ Folger 12/15/08 QA80-12778 v8.0986c DYNAMICALLY_CALCULATE_OPTIMAL_WIDTH_FOR_NLFIT_DIALOG
		m_nOptimalWidth = 650;
		///------ End DYNAMICALLY_CALCULATE_OPTIMAL_WIDTH_FOR_NLFIT_DIALOG
		m_bNoFitAgain = false; /// Hong 01/12/10 QA80-14948 NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN
	}

	~NLFitDlg()
	{
	}
protected:
	///Jasmine 10/25/06 REMEMBER_TOP_PANE_SIZE	 
	//virtual
	///------ Folger 02/11/09 QA80-13098-P1 NLFIT_RESIZE_BAD_WHEN_BOTTOM_PANE_IS_HIDDEN
	//int GetMinTopPaneHeight() { return 300;}
	int GetMinTopPaneHeight() { return 270;}
	///------ End NLFIT_RESIZE_BAD_WHEN_BOTTOM_PANE_IS_HIDDEN
	int GetMinBottomPaneHeight() { return 250;}
	///End REMEMBER_TOP_PANE_SIZE
//---- CPY 10/18/04	NLF_DOMODAL_FOR_FIT_EXP_DECAY_TYPE
public:
	int 	DoModalEx(TreeNode& trOp, NLFitSession* pFitSession, HWND hWndParent = NULL, const TreeNode& trFDF = NULL);
	
private:
	bool	saveAsTheme(LPCSTR lpcszThemeFilename);
	void 	arrangeParamsBoundControls(RECT *prTab = NULL, bool bParamsTab = true);
	void 	arrangeParamsInitConstrControls(bool bCodeTab = true);
	//--- CPY 4/23/07 SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS_BROKE_SETTINGS_RESIZE
	//void	arrangeTabControls(RECT& rTab);
	int		arrangeTabControls(RECT& rTab);
	void    arrangeSettingsCodeControls(int nSelTab, RECT &rTab);
	//---
	/// Hong 20/05/08 v8.0867 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
	//void	updateParamsInitAndLinearConstraEnable(uint wParam, uint lParam);
	/// end CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
	///end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
	
	bool	customParamRowsShow(bool bUpdateGird = true); /// Iris 3/15/2008 v8.0825 ADD_DLG_TO_HIDE_SHOW_PARAM
	
	void 	showMsgTab(); //Arvin 04/02/08 QA70-11348 AUTO_PREVIEW_CHANGED_TO_AUTO_UPDATE_CLEANUP
	
	void updateButtonsState(bool bEnable = true); ///Arvin 04/08/08 QA70-11348-P2 DISABLE_BUTTONS_WHEN_INIT_FAIL_OR_FIND_LESS_PEAKS
//----
public:	
	BOOL	OnQuickSetParameterChange(DWORD wParam, DWORD lParam);		///Kyle 11/04/2008 QUICK_SET_PARAMETERS_VALUE_CHANGE
	
	BOOL	OnResetParamBounds(DWORD wParam, DWORD lParam); /// Hong 01/23/09 MORE_PRECISE_BOUND_CLEAR_AND_RESET_CONTEXT_MENU
	
	BOOL OnQuickSetParam(Control ctrl); 					///Kyle 10/22/08 QA80-12401 QUICK_SET_ONE_PARAM_VALUE_TO_ALL

	BOOL	OnSortPeaks(Control ctrl);						//------ Folger 10/24/08 v8.0960 SUPPORT_SORT_PEAKS_FOR_REPLICA
	
	BOOL	OnReorderPeaks(Control ctrl);		//------ Folger 11/05/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING

	/// Iris 3/02/06 SUPPORT_PFM_IN_NLFIT_DLG
	///// Iris 6/24/05 SEPARATE_NLSF_MENU_FOR_2D_3D_FUNC
	////int 	Create(HWND hWndParent = NULL);
	//int 	Create(HWND hWndParent = NULL, int nOption = 0);
	int 	Create(HWND hWndParent = NULL, int nOption = 0, TreeNode& trPFM = NULL);
	/////end SEPARATE_NLSF_MENU_FOR_2D_3D_FUNC
	/// End SUPPORT_PFM_IN_NLFIT_DLG

	BOOL 	OnInitDialog();
	BOOL	OnDestroy();
	BOOL	OnReady();// *	CPY 9/22/05 SPLITTER_INIT_SIZE_ON_READY
	BOOL 	OnDlgResize(int nType, int cx, int cy);
	BOOL 	OnHelp(int &nHelpID, int nIdCtrlFocus);
	BOOL 	OnInitSize(int &left, int &top, int &right, int  &bottom);
	BOOL 	OnClickOK();
	BOOL 	OnClickCancel();
	BOOL 	OnClickDone(Control ctrl); /// Hong 01/12/10 QA80-14948 NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN
	BOOL 	OnClickFit(Control ctrl);
	BOOL 	OnClickOneIter(Control ctrl);
	BOOL 	OnClickChiSQ(Control ctrl);
	BOOL	OnClickInit(Control ctrl);
	//BOOL 	OnShowBottomPane(Control cntrl);
	BOOL 	OnShowTopPane(Control cntrl);
	BOOL	OnTopTabChange(Control cntrl);
	BOOL	OnBottomTabChange(Control cntrl);
	BOOL 	SelTopTab(int nSel, DWORD dw = 0);			///Jasmine 10/28/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB
	BOOL 	OnShowMenu(UINT nResIDCtrl, int nx, int ny);	///Jasmine 10/28/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB
	///------ Folger 04/13/10 QA81-15297-P1 ACTIVE_HINT_TAB_WHEN_USER_SELECT_CONSTRAIN_ROW_WITH_EMPTY_CONTENTS
	BOOL	OnActiveBottomTab(uint wParam, uint lParam);
	///------ End ACTIVE_HINT_TAB_WHEN_USER_SELECT_CONSTRAIN_ROW_WITH_EMPTY_CONTENTS
	BOOL 	OnComboChangeTheme(Control ctrl);
	BOOL	OnSaveTheme(Control ctrl);
	BOOL	OnSaveThemeAs(Control ctrl);
	BOOL 	OnClickApplyParamSettings(Control ctrl);
	BOOL 	OnClickEnableAutoInitParams(Control ctrl);
	///Cheney 2007-6-6 SUPPORT_LINEAR_CONSTRAINT_IN_NLFIT
	BOOL 	OnClickEnableLinearConstraints(Control ctrl);
	///end SUPPORT_LINEAR_CONSTRAINT_IN_NLFIT
	///Cheney 2007-4-29 SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
	BOOL 	OnClickApplyBoundSettings(Control ctrl);
	///end SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
	///Arvin 03/31/08 QA70-11322 ADD_AUTO_UPDATE_PREVIEW_CHECKBOX
	BOOL 	OnClickAutoUpdate(Control ctrl);
	///end ADD_AUTO_UPDATE_PREVIEW_CHECKBOX
	BOOL 	OnFunctionChange(uint wParam, uint lParam);
	BOOL 	OnDataChange(uint wParam, uint lParam);  /// Iris 7/24/06 ADD_FIT_CURVE_PREVIEW_TAB	
	//--- CPY 12/15/06 NLFIT_NOT_COMPILABLE
	//BOOL	OnButtonEnable(uint wParam, uint lParam);///Sophy 9/8/2008 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
	BOOL	OnResizeErrMsg(uint wParam, uint lParam);
	//---
	void 	OnAfterEditParaControl(Control flxControl, int nRow, int nCol);
	void 	OnBeforeEditParaControl(Control flxControl, long nRow, long nCol, BOOL* pCancel);
	void 	OnBeforeMouseDownParaControl(Control cntrl, short nButton, short nShift, float X, float Y, BOOL* pCancel);
	void 	OnMouseMoveParaControl(Control cntrl, short nButton, short nShift, float X, float Y);
	//------ Folger 12/11/08 v8.0985 SUPPORT_DOUBLE_CLICK_TO_SWICH_BOUND_CONTROL
	//void	OnGridButtonClick(Control flxControl, int nRow, int nCol);
	void OnGridDBClick(Control flxControl);
	//------ End SUPPORT_DOUBLE_CLICK_TO_SWICH_BOUND_CONTROL
	BOOL	OnSelectionChange();
	BOOL	OnSelectionTrack();
	void	OnGridComboCloseUp(Control ctrl, int nRow, int nCol, BOOL* pFinishEdit);///Jasmine 03/09/06 ADD_EVENT_COMBO_CLOSE_UP
	BOOL	OnParamChange(uint wParam, uint lParam);
	BOOL	OnKeyDownWindow(Control oCntrl, UINT msg, UINT wParam, UINT lParam)	;
	BOOL	OnFitCurveOptionsChange(uint wParam, uint lParam); /// Iris 07/03/06 UPDATED_X_DATA_TYPE_FIT_BUTTON_MUST_ENABLE
	void	OnClickUpdateResidual(uint wParam, uint lParam); /// Iris 8/08/06 IMPROVE_RESIDUAL_PREVIEW
	/// Hong 01/21/08 QA80-10969 FITNL_SOPPURT_DO_PREVIEW_ON_SOURCE_GRAPHPAGE
	/// Hong 12/12/08 QA80-12733 ACTIVE_SELECTION_IN_GRAPH_LOST_IF_NOT_ACTIVE_PAGE_LEAD_INIT_INPUT_FAIL
	//BOOL	UpdatePreviewPage();
	BOOL	UpdatePreviewPage(bool bForceUpdate = false);
	/// end ACTIVE_SELECTION_IN_GRAPH_LOST_IF_NOT_ACTIVE_PAGE_LEAD_INIT_INPUT_FAIL
	/// end FITNL_SOPPURT_DO_PREVIEW_ON_SOURCE_GRAPHPAGE
	///Joseph	12/11/06	ADD__BITMAP_BUTTON
	BOOL 	OnClickOpenFO(Control ctrl);
	BOOL	OnClickSaveFDF(Control ctrl);
	///End	ADD__BITMAP_BUTTON
	
	BOOL	OnClickNewFO(Control ctrl);	///Sophy 6/2/2010 ORG-2 NEW_FIT_FUNCTION_WIZARD_IN_NLFIT_DLG
	
	BOOL	OnClickParamHide(Control ctrl); /// Iris 3/15/2008 v8.0825 ADD_DLG_TO_HIDE_SHOW_PARAM
	
	BOOL	OnClickSimplex(Control ctrl);  ///Joseph 06/22/07 v8.0647 ADD_NLF_SIMPLEX_BUTTON
	
	///Joseph 02/03/07 QA70-9327 DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
	BOOL	OnInitSize();
	BOOL	OnRestoreSize(DWORD dwSizeInfo);
	bool	GetDlgOptimalSize(SIZE& sz);
	///End DDK_SAVING_OF_OCDDK_DIALOG_PLACEMENTS
	
	BOOL	OnNumReplicaChange(uint wParam, uint lParam); /// Iris 02/02/2007 v8.0553 ADD_ASK_APPLY_PARAM_SETTINGS_THEME_CHECKBOX
		
	BOOL	SaveFDFOnValueChanged(uint wParam, uint lParam);			///Joseph 05/24/07 ADD_REMAINDER_MSG_WHEN_NEED_SAVE_FDF
	
	///Joseph 05/24/07 ADD_REMAINDER_MSG_WHEN_NEED_SAVE_FDF
	void	OnChangeFDFFileValue(uint wParam, uint lParam);
	///End ADD_REMAINDER_MSG_WHEN_NEED_SAVE_FDF
	/// Hong 09/11/08 v8.0937 CLEAN_GRID_UPDATE_MECHASNISM_BASE_ON_PARAMETER_MANAGER
	/////Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC	
	//bool	UpdateFitSessionParamsFromGrid(uint wParam, uint lParam);
	/////end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
	/// end CLEAN_GRID_UPDATE_MECHASNISM_BASE_ON_PARAMETER_MANAGER
	void	UpdateOneLineMessageBox(uint wParam, uint lParam); ///Cheney 2007-8-7 IF_FIT_CONVERGE_SHOW_OK_BUTTON_OTHERWISE_FIT_BUTTON	
	void 	OnUpdateHints(uint wParam, bool bUpdate = true);///Jasmine 09/18/07 QA70-10393 NLFIT_HINTS	
	
	BOOL	OnNLFitDlgUpdate(DWORD wParam, DWORD lParam);
	
	//------ Folger 03/03/08 QA80-11192 ADD_THEME_CONTROL_POPUP_MENU
#ifdef THEME_CONTROL_POPUP_MENU
	///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	/*
	void	OnThemeSave(uint wParam, uint lParam);
	void	OnThemeSaveAs(uint wParam, uint lParam);
	void	OnThemeChange(uint wParam, uint lParam);
	///---Sim 04-07-2008 QA80-11371 THEME_SAVING_OPTIONS
	void	OnThemeSetting(uint wParam, uint lParam);
	BOOL	IsThemeSetting(uint wParam, uint lParam);
	///---END QA80-11371 THEME_SAVING_OPTIONS
	
	void	UpdateSettingBeforeSaveTheme(TreeNode &tr);
	*/
	BOOL	OnLoadTheme(uint wParam, uint lParam);
	///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
#endif
	//------
	
	/// Hong 11/21/08 QA80-12505 NLFIT_NEED_DATASET_CHANGE_MONITER_ALLOW_CHANGE_DATA_AFTER_OPEN_DLG	
	BOOL 	OnDataChangebyUserEdit(string str);
	/// end NLFIT_NEED_DATASET_CHANGE_MONITER_ALLOW_CHANGE_DATA_AFTER_OPEN_DLG	
	
	/// Hong 09/24/09 QA80-14350 NLFIT_DLG_NEED_HINT_TO_GUIDE_USER_MAKE_IT_MODALLESS
	BOOL	OnClickOutside(DWORD wParam, DWORD lParam);
	/// end NLFIT_DLG_NEED_HINT_TO_GUIDE_USER_MAKE_IT_MODALLESS
	
	DECLARE_MESSAGE_MAP
protected:
	//---- CPY 1/15/05 XF_DLG_CODE_CLEANUP
	//virtual 
	int GetBottomPaneSubControls(vector<uint>& vnCntrls);
	//----
	int		UpdateBottomPaneSubControls(); /// Iris 7/24/06 ADD_FIT_CURVE_PREVIEW_TAB	

	///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	bool	LoadTheme();
	///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	
	///Sophy 6/2/2010 ORG-2 NEW_FIT_FUNCTION_WIZARD_IN_NLFIT_DLG
	BOOL	OpenFitFunctionWizard(bool bCreate = false); //if not bCreate, edit existing function
	///end NEW_FIT_FUNCTION_WIZARD_IN_NLFIT_DLG
private :
	/// Hong 10/08/08 QA80-12345 v8.0952c ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	void	onThemeValueChange(bool bReset = false, bool bOnlyCheckCurSel = true);
	/// end ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	
	/// Hong 09/11/08 v8.0937 FIX_BOUND_TAB_NOT_UPDATE_AFTER_ITERATE	
	/// Hong 07/03/09 QA80-13590-P4 ONLY_SWITCH_TO_MSG_TAB_FOR_KEY_MSG_LIKE_CLICK_FIT_BTNS
	//void	updateDisplayOnParamsChange();
	void	updateDisplayOnParamsChange(bool bForceShowResult = false);
	/// end ONLY_SWITCH_TO_MSG_TAB_FOR_KEY_MSG_LIKE_CLICK_FIT_BTNS
	/// end FIX_BOUND_TAB_NOT_UPDATE_AFTER_ITERATE
	
	int		moveShownControlToTopTab();
	//int		moveAndshowControlInBottomTab();
	bool	updateTopPaneControlShow();
	//void	hideAllControlInBottomPane();
	///Cheney 2007-4-19 SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS	
	bool	updateParamsInitAndConstrShow(bool bCodeTab = false, DWORD dwShowCheckBox = 0);
	///end SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS
	///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC	
	//bool	updateFitSessionParamsFromGrid();
	
	/// Hong 09/11/08 v8.0937 CLEAN_GRID_UPDATE_MECHASNISM_BASE_ON_PARAMETER_MANAGER
	////------ Folger 03/25/08 QA80-11304 SUPPORT_SHARED_PARAMETERS_IN_REPLICA_FITTING
	////bool	updateFitSessionParamsFromGrid(int nSharedMode = SHARE_SETTING_MODE_NOT_CHANGE); /// Hong QA80-10937 FIX_SWITCH_FIT_MODE_FAIL_CORRECT_DEAL_SHARED_SETTINGS
	//bool	updateFitSessionParamsFromGrid(int nSharedMode = SHARE_SETTING_MODE_NOT_CHANGE, bool bKeepParams = false);
	////------
	/// end CLEAN_GRID_UPDATE_MECHASNISM_BASE_ON_PARAMETER_MANAGER

	///end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
	void	updateFitButtonText(bool bOK = true);	///Cheney 2007-8-7 IF_FIT_CONVERGE_SHOW_OK_BUTTON_OTHERWISE_FIT_BUTTON	
	
	/// Hong 03/21/08 v8.0828 GENTRALIZE_CODE_ACCORDING_TO_DRY_PRINCIPLE
	//	bottom tab support add/remove first tab item NLF_FIT_CURVE_PREVIEW_TAB dynamic,
	//	so need to convert carefully dealing with enum identifier
	int 	bottomTabSelToEnum(int nSel);
	int 	bottomTabEnumToSel(int nEnum);
	/// end GENTRALIZE_CODE_ACCORDING_TO_DRY_PRINCIPLE
private:
	void	updateTopTabDisplay();
	//--- CPY 10/25/04 ADD_SHOW_MSG_LOG_WHEN_CLICK_FIT, added nTabToShow
	//void 	updateBottomTabDisplay();
	/// Hong 09/13/08 v8.0938 IMPROVE_BY_AVOID_UPDATE_WHEN_TAB_IS_HIDDEN
	//void 	updateBottomTabDisplay(int nTabToShow = -1);
	void 	updateBottomTabDisplay(int nTabToUpdate = -1);
	/// end IMPROVE_BY_AVOID_UPDATE_WHEN_TAB_IS_HIDDEN
	void	updateDialogTitle();
	/// Hong 03/20/08 QA80-11286 FIX_ACTIVE_CODE_TAB_FAIL_UPDATE_SWITCH_THEME
	//void 	updateDisplay(bool bParamsGrid = true, bool bFitButtons = true, bool bNumParamsChanged = false);//--- CPY 11/1/04 PARAM_INIT_BUTTON_CODE_CLEAN_UP
	/// Hong 07/03/09 QA80-13590-P4 ONLY_SWITCH_TO_MSG_TAB_FOR_KEY_MSG_LIKE_CLICK_FIT_BTNS
	//void 	updateDisplay(bool bParamsGrid = true, bool bFitButtons = true, bool bNumParamsChanged = false, bool bUpdateCodeTab = false);
	void 	updateDisplay(bool bParamsGrid = true, bool bFitButtons = true, bool bNumParamsChanged = false, bool bUpdateCodeTab = false, bool bForceShowResult = false);
	/// end ONLY_SWITCH_TO_MSG_TAB_FOR_KEY_MSG_LIKE_CLICK_FIT_BTNS
	/// end FIX_ACTIVE_CODE_TAB_FAIL_UPDATE_SWITCH_THEME
	//---
	
	/// Iris 7/24/06 ADD_FIT_CURVE_PREVIEW_TAB	
	bool 	initTabFitCurvePreview(bool bIsResidual);  
	/// Hong 09/13/08 v8.0938 IMPROVE_BY_AVOID_UPDATE_WHEN_TAB_IS_HIDDEN
	/*
	bool 	setTabFitCurvePreview(bool bIsResidual);	
	///end ADD_FIT_CURVE_PREVIEW_TAB
	void	setMessageLogShow(bool bShow = true);	
	bool 	setTabOperatrLog();
	bool 	setTabFuncCurvePreview(bool bFormular);	
	/// Hong 03/20/08 v8.0828 CENTRALIZED_CODE
	////bool 	setTabParameterControl();///Jasmine 02/09/06 ADD_PARA_BOUND_TAB
	//bool 	setTabParameterControl(int nSelTab);
	/// end CENTRALIZED_CODE
	bool	setFunctionFormulaPreview( bool bFormular );
	*/
	/// end IMPROVE_BY_AVOID_UPDATE_WHEN_TAB_IS_HIDDEN
	//bool 	isFunctionTreeInvalid();	///DG ACCESS_FUNCTION_BY_NFO	

	//bool	OutputOperationLog(string &strOutput = NULL );	
	//string	getOperationLog();	
	/// YuI 8/24/04 QA70-4387 NLFITTER_OPERATION_IMPLEMENTATION
	void	beforeFit();
	/// end NLFITTER_OPERATION_IMPLEMENTATION
	void	afterFit(bool bUpdateDisplay = true);		
	
	///Sophy 11/26/2008 v8.980 SHOULD_DISABLE_FITBUTTON_WHEN_HAS_ERR_MSG
	//void	updateShowButtons(bool bForceShowResults = false);
	void	updateShowButtons(bool bForceShowResults = false, DWORD& dwEnables = NULL, bool bUpdateOKButton = true);
	///end SHOULD_DISABLE_FITBUTTON_WHEN_HAS_ERR_MSG

	///---Sim 10-09-2008 QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	//void	loadThemeFilesToCombo(TreeNode& trGUI);
	//void	updateSaveButton(const string& strSelTheme);
	///---END QA80-12345 ADD_STAR_INDICATE_THEME_VALUE_CHANGE
	bool 	setTabFunctionFileShow();
	
	///Iris 10/11/06 v8.0494b ADD_ONE_LINE_MESSAGE_BAR
	void    updateOneLineMessageSize();  
	/// Hong 09/13/08 v8.0938 IMPROVE_BY_AVOID_UPDATE_WHEN_TAB_IS_HIDDEN
	//bool	isShowOneLineMessage(int nSelTab);
	bool	isShowOneLineMessage();	
	/// end IMPROVE_BY_AVOID_UPDATE_WHEN_TAB_IS_HIDDEN
	///end ADD_ONE_LINE_MESSAGE_BAR		

	void	updateOneLineMessageBox();
	/// Hong 09/13/08 v8.0938 IMPROVE_BY_AVOID_UPDATE_WHEN_TAB_IS_HIDDEN
	void	updateBottomPaneSubControlsShowStatus();
	void	setBottomPaneActiveTab(int nTabToShow = -1);
	/// end IMPROVE_BY_AVOID_UPDATE_WHEN_TAB_IS_HIDDEN
	
	///Cheney 2007-4-29 SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
	//bool    updateStaticNumReplica();/// Iris 02/02/2007 v8.0553 ADD_ASK_APPLY_PARAM_SETTINGS_THEME_CHECKBOX
	///Arvin 03/26/08 RESET_REPLICA_NUMBER_WHEN_CAN_NOT_FIND_ENOUGH_PEAK
	//bool    updateStaticNumReplica(int nSelTab);/// Iris 02/02/2007 v8.0553 ADD_ASK_APPLY_PARAM_SETTINGS_THEME_CHECKBOX
	bool    updateStaticNumReplica(int nSelTab, bool bShowMsgTab = false);/// Iris 02/02/2007 v8.0553 ADD_ASK_APPLY_PARAM_SETTINGS_THEME_CHECKBOX
	///end RESET_REPLICA_NUMBER_WHEN_CAN_NOT_FIND_ENOUGH_PEAK
	///end SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
	bool 	isFactoryDefaultTheme();
	
	void 	hideThemeControls(int nEdge, RECT& rTab);	///Joseph 04/17/07 ADD_NLSF_NO_THEME_DLG
	
	bool 	setTabOperationHintShow();	///Joseph 05/16/07 ADD_HINT_TAB_TO_NLSF
	
	
	///Joseph 05/24/07 ADD_REMAINDER_MSG_WHEN_NEED_SAVE_FDF
	bool 	isFuncUserDefined();	
	///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
	//void	saveFDFOnValueChanged();	
	void	saveFDFOnValueChanged(bool bChangeTheme = false);
	///end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
	bool	saveFDFFile();
	///End ADD_REMAINDER_MSG_WHEN_NEED_SAVE_FDF	
	
	///Cheney 2007-6-8 ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC	
	//void	onChangeFDFFileValue(uint wParam);	
	/// Hong 04/23/08 QA80-11466 THEME_CHANGE_NOT_TRIGGER_MIDOFY_FLAG_IN_DLG_BUT_FO_USE_CHANGE_FDF
	//void 	onChangeFDFFileValue(int nFDFValueChange, bool bChangeFunc = false);
	void 	onChangeFDFFileValue(int nFDFValueChange, int nChangeFrom = 0);
	/// end THEME_CHANGE_NOT_TRIGGER_MIDOFY_FLAG_IN_DLG_BUT_FO_USE_CHANGE_FDF
	void	updateDlgSettingIfNoFDFValChange();
	bool	getFuncListFromChangeFuncsTree(vector<string>& vsFunctions);
	///end ALLOW_USER_EDIT_LINEAR_CONSTRINTS_WHEN_USE_BUILDIN_FUNC
	
	//------ Folger 11/13/07 GET_TAB_CHM_HELP
	int		getFocusTabID();
	//------ End GET_TAB_CHM_HELP
	int		updateObjects( DWORD dwObject, DWORD dwParam );///Sophy 9/8/2008 CLEAN_UPDATE_EVENTS_TO_ONE_FUNCTION
	int		updateParts(DWORD dwParts);
	
	//------ Folger 10/24/08 v8.0960 CENTRALIZE_CODE_ABOUT_UPDATING_ON_PARAMETER_CHANGE
	void	updateOnParameterChange(int nUpdateParts, DWORD dwUpdateBits = FITPREVIEW_UPDATE);
	//------

	//------ Folger 10/24/08 v8.0960 SUPPORT_SORT_PEAKS_FOR_REPLICA
	void	enablePeakSortingButton(bool bEnable);
	//------

	//------ Folger 11/05/08 QA80-12509 v8.0965 SUPPORT_BOTH_PEAKS_SORTING_AND_REORDERING_FOR_MULTIPLE_PEAKS_FITTING
	void	enablePeakReorderingButton(bool bEnable);
	//------
	
	/// Hong 11/21/08 QA80-12505 NLFIT_NEED_DATASET_CHANGE_MONITER_ALLOW_CHANGE_DATA_AFTER_OPEN_DLG		
	void	updateMonitorDatasetNames();
	/// end NLFIT_NEED_DATASET_CHANGE_MONITER_ALLOW_CHANGE_DATA_AFTER_OPEN_DLG
	
	///------ Folger 12/15/08 QA80-12778 v8.0986c DYNAMICALLY_CALCULATE_OPTIMAL_WIDTH_FOR_NLFIT_DIALOG
	int		getButtonIDs(vector<uint>& vnButtonIDs);
	void	calcOptimalWidth();
	///------ End DYNAMICALLY_CALCULATE_OPTIMAL_WIDTH_FOR_NLFIT_DIALOG
	
private :
	NLFitSplitter		m_NLF;
	NFPreviewControl	m_NFunctionPrev;
	NFPreviewControl	m_NCurvePrev;
	//RichEdit			m_reOperationLog;
	OperationLog		m_OPMsgLog;
	RichEditEx			m_reditFunctionFile;	 
	
	Edit				m_editHint;	///Joseph 05/16/07 ADD_HINT_TAB_TO_NLSF
	bool				m_bFirstTimeResize;	
	//bool 				m_bIsFirstTime;
	//NLFitParamsControl	m_GridParas;///Jasmine 02/09/06 ADD_PARA_BOUND_TAB
#ifdef _NLF_PARAMS_TAB //---CPY 11/12/06 MARKO_FOUND_CANCEL_CRASH_COMES_FROM_PARAMS_GRID
	//NLFitParamsColControl	m_GridParas;
	/// Iris 10/29/2008 QA80-12401-P4 QUICK_SET_DLG_ADD_APPLY_BUUTON
	//NLFParamsControl	m_GridParas;
	NLFParamsControl*	m_pGridParas;
	///end QUICK_SET_DLG_ADD_APPLY_BUUTON
#endif
	TabControl			m_TopTab;
	ParamTabs			m_paramTabs;	///Jasmine 10/24/08 QA80-12425 CUSTOMIZATION_PARAMETER_TAB
	//TabControl			m_BottomTab; CPY 1/15/05 XF_DLG_CODE_CLEANUP moved this to base class
	Control				m_btnOK;
	/// Hong 01/12/10 QA80-14948 NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN
	Control				m_btnDone;
	BOOL				m_bNoFitAgain;
	/// end NLFIT_SUPPORT_OK_BTN_WHICH_DONOT_FIT_AGAIN
	///Joseph	
	//Control				m_btnFit;
	BitmapRadioButton	m_btnFit;
	///End
	//---- CPY 12/15/06 NLF_CANNOT_COMPILE
//	Control				m_btnFit1;
//	Control				m_btnGetChiSQ;
	BitmapRadioButton	m_btnFit1, m_btnGetChiSQ;
	//----
	ComboBox			m_comboTheme;
	//--------Folger 07/20/07 USE_BITMAP_RADIO_BUTTON_INSTEAD_OF_TEXT_BUTTON
	//Control				m_btnSaveTheme;
	BitmapRadioButton	m_btnSaveTheme;
	//--------End USE_BITMAP_RADIO_BUTTON_INSTEAD_OF_TEXT_BUTTON
	///Joseph	12/11/06	ADD__BITMAP_BUTTON
	//Control				m_btnInit;
	BitmapRadioButton	m_btnInit;
	///End ADD__BITMAP_BUTTON
	Control				m_ctrlParamTabHint;  /// Iris 1/06/2009 QA81-14920 HINT_FOR_PARAM_BOUNDS_TAB
	Control				m_staticMessage; ///Iris 10/11/06 v8.0494b ADD_ONE_LINE_MESSAGE_BAR
	Button				m_checkApplyParamsTheme;
	Button				m_checkEnableAutoParamsInit; /// Iris 02/14/2007 v8.0562 ADD_CHECKBOX_TO_DISABLE_ENABLE_PARAMS_AUTO_INIT
	Control				m_staticNumReplica;
	Button				m_btnParamHide;
	///Cheney 2007-4-19 SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS
	Button				m_checkEnableConstraints;
	///end SHOW_CHECKBOX_FOR_PARAMS_INIT_AND_CONSTRAINTS
	///Cheney 2007-4-29 SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
	Button				m_checkApplyBoundTheme;
	///end SEPRATE_BOUND_SETTING_FROM_PARAMS_SETTING_CEHCK_BOX
	Button				m_checkEnableAutoUpdate;	///Arvin 03/31/08 QA70-11322 ADD_AUTO_UPDATE_PREVIEW_CHECKBOX
	vector<uint>		m_vnThemeSaveGroup;
	
	/// YuI 8/24/04 QA70-4387 NLFITTER_OPERATION_IMPLEMENTATION
//	DWORD				m_dwOperationUID;
	/// end NLFITTER_OPERATION_IMPLEMENTATION

	/// Iris 6/24/05 SEPARATE_NLSF_MENU_FOR_2D_3D_FUNC
	int					m_nFuncOption;
	///Cheney 2006-11-16 SHOULD_REFRESH_GRAPH_ONLY_IF_CURRENT_TAB_IS_GRAPH
	GraphPage		 	m_gpFitCurve;
	GraphPage		 	m_gpResidual;
	///end SHOULD_REFRESH_GRAPH_ONLY_IF_CURRENT_TAB_IS_GRAPH
	///Joseph	12/11/06	ADD__BITMAP_BUTTON
	BitmapRadioButton	m_SelFuncButton;	
	BitmapRadioButton	m_SaveFDFButton;
	///End	ADD__BITMAP_BUTTON
	///Sophy 6/2/2010 ORG-2 NEW_FIT_FUNCTION_WIZARD_IN_NLFIT_DLG
	BitmapRadioButton	m_NewFuncButton;
	///end NEW_FIT_FUNCTION_WIZARD_IN_NLFIT_DLG
	
	BitmapRadioButton 	m_SimplexButton; ///Joseph 06/22/07 v8.0647 ADD_NLF_SIMPLEX_BUTTON
	
	PEVENT_GETN			m_pNewEventFunc;	///Joseph 01/30/06	ADD_OPERATION_ERRMSG_LINE
		
	bool	m_bInFitIterate;//CPY TD 3/16/2007 QA70-9473 NLFIT_NEEDS_FEEDBACK_TO_USER_AND_ESC_TO_ABORT_FITTING
	
	
	uint	m_nFDFValueChange;///Joseph 05/24/07 ADD_REMAINDER_MSG_WHEN_NEED_SAVE_FDF
	
	Control		m_ctrlExplanationText;		//------ Folger 01/03/08 ADD_SELECTION_EXPLANATION_TO_CODE_TAB
	/// Hong 03/20/08 v8.0828 CHNAGE_TO_MORE_PRECISE_NAME
	//BOOL		m_bPreviewPage;	/// Hong 01/21/08 QA80-10969 FITNL_SOPPURT_DO_PREVIEW_ON_SOURCE_GRAPHPAGE
	BOOL		m_bPreviewSrcPage;
	/// end CHNAGE_TO_MORE_PRECISE_NAME
	
	vector<int>		m_vnParamsHide;
	
	/// Hong 11/21/08 QA80-12505 NLFIT_NEED_DATASET_CHANGE_MONITER_ALLOW_CHANGE_DATA_AFTER_OPEN_DLG
	StringArray		m_saSrcDatasetNames;	
	/// end NLFIT_NEED_DATASET_CHANGE_MONITER_ALLOW_CHANGE_DATA_AFTER_OPEN_DLG
	
	///------ Folger 12/15/08 QA80-12778 v8.0986c DYNAMICALLY_CALCULATE_OPTIMAL_WIDTH_FOR_NLFIT_DIALOG
	int				m_nOptimalWidth;
	///------ End DYNAMICALLY_CALCULATE_OPTIMAL_WIDTH_FOR_NLFIT_DIALOG
};

#endif //_NLFIT_DLG_H
